# Rand_treatments.R
# Random assignment of Example 2 treatments

# Load necessary libraries
library(plyr)

# Read in data set
tttdata <- read.table(header=T,colClasses=c("factor","factor"),text="
nitrogen water 
 40  125
 40  125
 40  125
 40  125
 40  250
 40  250
 40  250
 40  250
 40  375
 40  375
 40  375
 40  375
 80  125
 80  125
 80  125
 80  125
 80  250
 80  250
 80  250
 80  250
 80  375
 80  375
 80  375
 80  375
 120  125
 120  125
 120  125
 120  125
 120  250
 120  250
 120  250
 120  250
 120  375
 120  375
 120  375
 120  375
")

# Generate a uniform random variable
tttdata <- transform(tttdata,u=runif(dim(tttdata)[1]))

# Original order of treatments
tttdata

# Sort treatments by value of u
tttsort <- arrange(tttdata,u)

# Randomly shuffled treatments
tttsort
